document.addEventListener('DOMContentLoaded', () => {
    const toggleButton = document.querySelector('.navbar-toggle');
    const mobileMenu = document.querySelector('.mobile-menu');

    toggleButton.addEventListener('click', () => {
        mobileMenu.classList.toggle('mobile-menu-active');
    })
})

function initMap() {
    const torreQuadrata = {lat: 19.3933663, lng: -99.2417671}; 

    var map = new google.maps.Map(
        document.getElementById('map'), {zoom: 15, center: torreQuadrata});

    // Marcador en Torre Quadrata
    var marker = new google.maps.Marker({position: torreQuadrata, map: map});
}

document.getElementById('formularioPrestamo').addEventListener('submit', function(event) {
    event.preventDefault();
    
    const monto = document.getElementById('monto').value;
    const plazos = document.getElementById('plazos').value;
    
    const pago1 = (monto / plazos) + (monto * 0.0198 / 2)
    const pago2 = (monto / plazos) + (monto * 0.0298 / 2)
    const pago3 = (monto / plazos) + (monto * 0.0398 / 2)

    let result1 = document.getElementById('one')
    result1.innerHTML = `
        <p><strong>${pago1.toFixed(2)}</strong></p>
    `;
    
    let result2 = document.getElementById('two')
    result2.innerHTML = `
        <p><strong>${pago2.toFixed(2)}</strong></p>
    `;

    let result3 = document.getElementById('three')
    result3.innerHTML = `
        <p><strong>${pago3.toFixed(2)}</strong></p>
    `;
});